<?php
require_once "conexion.php";

class ModeloDirecciones{

    static public function mdlCrearDireccion($idzona, $nombreDireccion){
        //INSERT INTO direcciones (id_zona, nombre_direccion) VALUES (1, "Vergel")
        $stmt = Conexion::conectar()->prepare("INSERT INTO direcciones (id_zona, nombre_direccion) VALUES (:idzona, :nombre_direccion)");
        $stmt->bindParam(":idzona", $idzona, PDO::PARAM_INT);
        $stmt->bindParam(":nombre_direccion", $nombreDireccion, PDO::PARAM_STR);
        if($stmt->execute()){
            return "ok";
        }else {
            return "error";
        }
		$stmt = null;
    }

    static public function mdlEditarDireccion($datos){
        //UPDATE direcciones SET nombre_direccion = "jardinnn", id_zona = 15 WHERE iddireccion = 1
        $stmt = Conexion::conectar()->prepare("UPDATE direcciones SET nombre_direccion = :nombre_direccion, id_zona = :id_zona WHERE iddireccion = :iddireccion");
        $stmt->bindParam(":nombre_direccion", $datos['nombre'], PDO::PARAM_STR);
        $stmt->bindParam(":id_zona", $datos['id_zona'], PDO::PARAM_INT);
        $stmt->bindParam(":iddireccion", $datos['iddireccion'], PDO::PARAM_INT);
        if($stmt->execute()){
            return "ok";
        } else {
            return "error";
        }
       
		$stmt = null;
    }
 
    //funciones para query de zona
    static public function mdlCrearZona($zona){
        //INSERT INTO zona (nombre_zona) VALUES ("zona 1")
        $stmt = Conexion::conectar()->prepare("INSERT INTO zona (nombre_zona) VALUES (:nombre_zona)");
        $stmt->bindParam(":nombre_zona", $zona, PDO::PARAM_STR);
        if($stmt->execute()){
            return "ok";
        }else {
            return "error";
        }
		$stmt = null;
    }

    static public function mdlEditarZona($datos){
        $stmt = Conexion::conectar()->prepare("UPDATE zona SET nombre_zona = :nombre_zona WHERE idzona = :idzona");
        $stmt->bindParam(":nombre_zona", $datos['nombre'], PDO::PARAM_STR);
        $stmt->bindParam(":idzona", $datos['id'], PDO::PARAM_INT);
        if($stmt->execute()){
            return "ok";
        } else {
            return "error";
        }
       
		$stmt = null;
    }

    static public function mdlMostrarUbicacion($tabla){
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");
        $stmt->execute();
        return $stmt->fetchAll();
		$stmt = null;
    }

    static public function mdlConsultarZonaId($tabla, $item, $id){
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
        $stmt->bindParam(":".$item, $id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
		$stmt = null;
    }

    static public function mdlEliminar($tabla, $item, $id){
        $stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE $item = :$item");
        $stmt->bindParam(":".$item, $id, PDO::PARAM_INT);
        if($stmt->execute()){
            return "ok";
        } else {
            return "error";
        }
        
		$stmt = null;
    }
}